/*
  (c) 2001 Nathan Hjelm <hjelmn@unm.edu>

  v0.4.1

  Driver to go with linux usbdevfs
*/

#include "driver.h"
#include "rio_usb.h"

#if defined(WITH_USBDEVFS)

struct usbdevice *rio_usb_open(void){
  struct usbdevice *tmp;
  // TODO --  Make this better
  // Try 600 then 800 then psa[play
  if ((tmp = usb_open(VENDOR_DIAMOND01, PRODUCT_RIO600, 5000)) != NULL)
    return tmp;
  else if ((tmp = usb_open(VENDOR_DIAMOND01, PRODUCT_RIO800, 5000)) != NULL)
    return tmp;
  else if ((tmp = usb_open(VENDOR_DIAMOND01, PRODUCT_PSAPLAY, 5000)) != NULL)
    return tmp;
  else
    return NULL;
}

/* from librio500-usbdevfs.c */
int bulk(struct usbdevice *dev, int ep, unsigned char *buffer, u_int32_t size){
  int transmitted = 0;
  void *data;
  int len;
  int ret;

  do {
    len = size - transmitted;
    data = (unsigned char *)buffer + transmitted;

    /* The 5000 is a timeout value */
    ret = usb_bulk_msg(dev, ep, len, data, 5000);
    if (ret < 0) {
      return -ret;
    }else{
      transmitted += ret;
    }
  } while (ret > 0 && transmitted < size);

  return transmitted;
}

int read_bulk(struct usbdevice *dev, unsigned char *buffer, u_int32_t size){
  return bulk(dev, USBRIO_BULK_IN | USB_DIR_IN, buffer, size);
}

int write_bulk(struct usbdevice *dev, unsigned char *buffer, u_int32_t size){
  int i;
  int j = 0;
  int ret = 0;
  int block_size = 4096;

  if (size < block_size)
    return bulk(dev, USBRIO_BULK_IN | USB_DIR_OUT, buffer, size);

  /* need to break up the data, but i am not sure why we are limited to only 4096 bytes at a time */
  for (i = size ; i > 0 ; i -= block_size, j++)
    ret += bulk(dev, USBRIO_BULK_IN | USB_DIR_OUT, &buffer[j * block_size], (i < block_size) ? i : block_size);

  return ret;
}

/* from rio500-usbdevfs.c */
int control_msg(struct usbdevice *dev, u_int8_t direction, u_int8_t request, u_int16_t value,
                              u_int16_t index, u_int16_t length, unsigned char *buffer){
  int ret;

  unsigned char requesttype = 0;

  if (direction == RIO_DIR_IN)
    requesttype = USB_DIR_IN |
      USB_TYPE_VENDOR | USB_RECIP_DEVICE;
  else
    requesttype = USB_DIR_OUT |
      USB_TYPE_VENDOR | USB_RECIP_DEVICE;

  /* The 5000 is a timeout value */
  ret = usb_control_msg(dev, requesttype, request, value, index, length, buffer, 5000);

  return (ret < 0) ? -1 : 0;
}

#endif /* WITH_USBDEVFS */
