#include <string.h>
#include <errno.h>

#include "config.h"

#ifdef HAVE_LIBGEN_H
#include <libgen.h>
#endif

#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>

#include "rio-cpp.h"
#include "rio-bsd.h"
#include "hexdump.h"

/*
  makeDownloadableInfo:
     Function takes in a file name and returns a
  complete Rio header struct that allows the file to
  be downloaded from the Rio.
*/
Info rioInstance::makeDownloadableInfo(const char *file_name){
  Info newInfo;
  rio_file *misc_file;
  struct stat statinfo;
  char *tmp1, *tmp2;

  if (stat(file_name, &statinfo) < 0){
    newInfo.data = NULL;
    return newInfo;
  }

  misc_file = new rio_file;
  bzero(misc_file, sizeof(rio_file));
  misc_file->size = statinfo.st_size;

  misc_file->mod_date = time(NULL);

  tmp1 = new char[strlen(file_name) + 1];
  bzero(tmp1, strlen(file_name) + 1);
  
  strncpy(tmp1, file_name, strlen(file_name));
  tmp2 = basename(tmp1);
  
  strncpy((char *)misc_file->name , tmp2, 63);
  strncpy((char *)misc_file->title, tmp2, 63);

  delete[] tmp2;

  newInfo.junk = 0;
  misc_file->bits = 0x10000591;

  newInfo.data = misc_file;

  return newInfo;
}
