// Hopefully with this we can wrap this back to c
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rio-cwrapper.h"

#ifdef __cplusplus
extern "C" {
#endif
  
  RIOEXPORT crioInstance
  init_instance(crioInstance player, int number, int debug, 
		int debugO, int output)
  {
    ostream *outp = NULL;
    if (output)
      outp = &cout;

    // TODO make this better!
    switch (debugO){
    case 1:
      player = new rioInstance(number, outp, &cerr, debug);
      break;
    case 0:
      player = new rioInstance(number, outp, &cout, debug);
      break;
    default:
      player = new rioInstance(number, outp, &cerr, debug);
      break;
    }
    return player;
  }
  
  RIOEXPORT int
  delete_instance(crioInstance player)
  {
    rioInstance *tmp = (rioInstance *)player;
    delete tmp;
    
    return 0;
  }
  
  RIOEXPORT int
  refresh_files(crioInstance player)
  {
    ((rioInstance *)player)->refreshFileList();
    return 0;
  }
  
  RIOEXPORT int
  iterate_files(crioInstance player, void (*f)(rio_file *))
  {
    ((rioInstance *)player)->iterate(f);
    return 0;
  }
  
  RIOEXPORT int
  set_progress(crioInstance player, void (*f)(int x, int X, void *)){
    ((rioInstance *)player)->setProgress(f, NULL);
    return 0;
  }
  
  RIOEXPORT int
  set_debug(crioInstance player, int i)
  {
    ((rioInstance *)player)->setDebugLevel(i);
    return 0;
  }
  
  RIOEXPORT int
  upload(crioInstance player, char *file, char *artist, char *title)
  {
    ((rioInstance *)player)->upload(file, artist, title);
    return 0;
  }
  
  RIOEXPORT int
  download(crioInstance player, int i)
  {
    ((rioInstance *)player)->download(i);
    return 0;
  }
  
  RIOEXPORT int
  update(crioInstance player, char *file)
  {
    ((rioInstance *)player)->update(file);
    return 0;
  }
  
  RIOEXPORT int
  format(crioInstance player)
  {
    ((rioInstance *)player)->format();
    return 0;
  }
  
  RIOEXPORT int
  delete_file(crioInstance player, int i)
  {
    ((rioInstance *)player)->delete_file(i);
    return 0;
  }
  
  
  RIOEXPORT char *
  return_name(crioInstance player)
  {
    return ((rioInstance *)player)->returnName();
  }
  
  RIOEXPORT void
  set_name(crioInstance player, char *name)
  {
    ((rioInstance *)player)->setName(name);
  }
  
  RIOEXPORT int
  return_volume(crioInstance player)
  {
    return ((rioInstance *)player)->returnVolume();
  }
  
  RIOEXPORT void
  set_volume(crioInstance player, int i)
  {
    ((rioInstance *)player)->setVolume(i);
  }
  
  
  RIOEXPORT int
  return_usage(crioInstance player)
  {
    return ((rioInstance *)player)->returnUsage();
  }
  
  RIOEXPORT int
  return_free(crioInstance player)
  {
    return ((rioInstance *)player)->returnFree();
  }
  
  RIOEXPORT double
  return_version(crioInstance player)
  {
    return ((rioInstance *)player)->returnFirm();
  }
  
  RIOEXPORT long int
  return_time(crioInstance player)
  {
    return ((rioInstance *)player)->returnTime();
  }
  
  RIOEXPORT int
  exists(crioInstance player)
  {
    if (((rioInstance *)player)->exists() == true)
      return 1;
    else
      return 0;
  }

  RIOEXPORT int
  return_type(crioInstance player)
  {
    return ((rioInstance *)player)->returnType();
  }
  
  RIOEXPORT int
  send_command(crioInstance player, int cmd, int arg1, int arg2, unsigned short int length)
  {
    ((rioInstance *)player)->send_command(cmd, arg1, arg2, length);
    return 0;
  }
  
  RIOEXPORT int
  return_num_memdev(crioInstance player)
  {
    return ((rioInstance *)player)->returnNumMemdev();
  }

  RIOEXPORT int
  return_eq_state(crioInstance player)
  {
    return ((rioInstance *)player)->returnEquilizerState();
  }

  RIOEXPORT int
  return_light_state(crioInstance player)
  {
    return ((rioInstance *)player)->returnLightState();
  }
  
  RIOEXPORT int
  return_contrast(crioInstance player)
  {
    return ((rioInstance *)player)->returnContrast();
  }
  
  RIOEXPORT int
  return_rep_state(crioInstance player)
  {
    return ((rioInstance *)player)->returnRepeatState();
  }
  
  RIOEXPORT int
  return_playlist(crioInstance player)
  {
    return ((rioInstance *)player)->returnPlaylist();
  }
#ifdef __cplusplus
}
#endif  
  
