/*
  bsd.cpp

  v0.2.2 Nathan Hjelm <hjelmn@unm.edu>

  Functions that are possibly missing.
*/
#include <string.h>
#include <sys/types.h>

#include "config.h"
#include "rio-bsd.h"

/* seems that neither freebsd or macos x have this */
#if defined(__FreeBSD__) || defined(__MacOSX__)

extern "C" {
  u_int32_t bswap_32(u_int32_t x){
    return ((x<<24) & 0xff000000) |
      ((x<<8 ) & 0x00ff0000) |
      ((x>>8 ) & 0x0000ff00) |
      ((x>>24) & 0x000000ff);
  }
}
#endif

#ifndef HAVE_LIBGEN_H
char *basename(char *x){
  int i;
  /* there is no / in x */
  if (strstr(x, "/") == NULL)
    return x;
 
  for (i = strlen(x) - 1 ; x[i] != '/'; i--);

  return &x[i+1];
}
#endif
