/*  ----------------------------------------------------------------------

    Copyright (C) 2000  Cesar Miquel  (miquel@df.uba.ar)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    ---------------------------------------------------------------------- */
#define VENDOR_DIAMOND00  0x0841
#define PRODUCT_RIO500    0x0001

#define VENDOR_DIAMOND01  0x045a

#define PRODUCT_RIO600    0x5001
#define PRODUCT_RIO800    0x5002
#define PRODUCT_PSAPLAY   0x5003     

#ifndef u_int16_t
#define u_int16_t short
#endif

struct RioCommand {
	u_int16_t length;
	int request;
	int requesttype;
	int value;
	int index;
	void *buffer;
	int timeout;
};

#if defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
#define RIO_SEND_COMMAND       _IOWR('U', 200, struct RioCommand)
#define RIO_RECV_COMMAND       _IOWR('U', 201, struct RioCommand)
#else
#define RIO_SEND_COMMAND                       0x1
#define RIO_RECV_COMMAND                       0x2
#endif

#define RIO_DIR_OUT                            0x0
#define RIO_DIR_IN                             0x1
