#ifndef RIO_CWRAPPER_H
#define RIO_CWRAPPER_H

#include <rio-cpp.h>

#ifdef __cplusplus
extern "C" {
#endif

  typedef void *crioInstance;

  RIOEXPORT crioInstance init_instance(crioInstance, int number, int debug, int debugO, int output);
  RIOEXPORT int delete_instance(crioInstance);

  RIOEXPORT int refresh_files(crioInstance);
  RIOEXPORT int iterate_files(crioInstance, void (*f)(rio_file *));
  
  RIOEXPORT int set_progress(crioInstance, void (*f)(int x, int X, void *));
  RIOEXPORT int set_debug(crioInstance, int);
  
  RIOEXPORT int upload(crioInstance, char *, char *, char *);
  RIOEXPORT int download(crioInstance, int);
  RIOEXPORT int update(crioInstance, char *);
  RIOEXPORT int format(crioInstance);
  RIOEXPORT int delete_file(crioInstance, int);
  
  RIOEXPORT char *return_name(crioInstance);
  RIOEXPORT void set_name(crioInstance, char *);
  
  RIOEXPORT int return_volume(crioInstance);
  RIOEXPORT void set_volume(crioInstance, int);
  
  RIOEXPORT int return_usage(crioInstance);
  RIOEXPORT int return_free(crioInstance);
  
  RIOEXPORT double return_version(crioInstance);
  RIOEXPORT long int return_time(crioInstance);
  
  RIOEXPORT int exists(crioInstance);
  RIOEXPORT int return_type(crioInstance);
  
  RIOEXPORT int send_command(crioInstance, int, int, int, unsigned short int);
  
  RIOEXPORT int return_num_memdev(crioInstance);

  RIOEXPORT int return_eq_state(crioInstance);
  RIOEXPORT int return_light_state(crioInstance);
  RIOEXPORT int return_contrast(crioInstance);
  RIOEXPORT int return_rep_state(crioInstance);
  RIOEXPORT int return_playlist(crioInstance);

#ifdef __cplusplus
}
#endif

#endif
