/*
 * $Id: rio600.h,v 1.12 2001/02/14 04:11:50 neo Exp $
 *
 * rio600.h
 * 
 * neo@vyger.penguinpowered.com
 * based from rio-600-0.1 by jasper (http://pointless.net/rio600/)
 *
 */

#ifndef __RIO600_H__33554432__
#define __RIO600_H__33554432__

/* transfer sizes */
#define RIO_MTS 2048 	 /* max transfer size  */
#define RIO_FTS 16384	 /* file transfer size */

#ifdef linux
#include <byteswap.h>
#include <endian.h>
#elif defined(__FreeBSD__) || defined(__MacOSX__)
#include <machine/endian.h>
#else
#include <sys/endian.h>
#include <sys/bswap.h>
#define bswap_32 bswap32
#endif /* linux */

/* ERRORS */
#define ENORIO            -31    /* no rio */
#define ERIORDY           -32    /* rio not ready */
#define ERIOOFF           -33    /* rio is off */
#define ERIOFULL          -34    /* rio has no room */

#define RIOEXPORT

/* 
   commands 
   many of these commands may do nothing
*/
#define UNKNOWN00  0x60
#define RIO_POLLD  0x61 /* not sure on this one */
#define RIO_DESCP  0x62 /* description of the device */
#define RIO_TYPEQ  0x63
#define NOCOMMAN1  0x64 /* this is not a command */
#define UNKNOWN01  0x65
#define UNKNOWN02  0x66
#define UNKNOWN03  0x67
#define RIO_MEMRI  0x68 /* what storage do we have */
#define RIO_FILEI  0x69 /* loop through files */
#define RIO_FORMT  0x6a /* this returns SRIOFMTD....Done if successful */
#define RIO_UPDAT  0x6b /* update firmware */
#define RIO_WRITE  0x6c
#define UNKNOWN04  0x6d
#define UNKNOWN05  0x6e
#define UNKNOWN06  0x6f
#define RIO_READF  0x70
/* 71 -- 76 do nothing */
#define UNKNOWN07  0x77 /* clears the screen on the rio ??? */
#define RIO_DELET  0x78
#define RIO_PREFS  0x79 /* write prefs.   2kB */
#define RIO_PREFR  0x7a /* returns prefs. 2kB */
#define RIO_TIMES  0x7b /* set time */
#define UNKNOWN08  0x7c
#define UNKNOWN09  0x7d
#define UNKNOWN10  0x7e
#define UNKNOWN11  0x7f

/*
  file types
*/
#define TYPE_MP3  0x3347504d
#define TYPE_WMA  0x20414d57
#define TYPE_WAV  0x504c4341
#define TYPE_WAVE 0x45564157

#include "rio-struct.h"

#if defined(WITH_USBDEVFS)
#include <asm/types.h>

struct usb_device_descriptor_x {
        __u8  bLength;
        __u8  bDescriptorType;
        __u8  bcdUSB[2];
        __u8  bDeviceClass;
        __u8  bDeviceSubClass;
        __u8  bDeviceProtocol;
        __u8  bMaxPacketSize0;
        __u8  idVendor[2];
        __u8  idProduct[2];
        __u8  bcdDevice[2];
        __u8  iManufacturer;
        __u8  iProduct;
        __u8  iSerialNumber;
        __u8  bNumConfigurations;
};

struct usbdevice {
  int fd;
  struct usb_device_descriptor_x desc;
};
#elif defined(__MacOSX__)
#include <IOKit/IOCFBundle.h>
#include <IOKit/usb/IOUSBLib.h>

struct usbdevice {
  IOUSBDeviceInterface **device;
  IOUSBInterfaceInterface **interface;
};
#elif defined(WITH_LIBUSB)

#if defined(__cplusplus)
extern "C" {
#endif

#include <usb.h>

#define usbdevice usb_dev_handle

#if defined(__cplusplus)
}
#endif

#else
struct usbdevice {
  int fd;
};
#endif

#if defined(__cplusplus)

#include <iostream.h>

/**
 * The info structure hold both the completed header structure
 * and the amount of junk rioutil needs to skip over
 **/
typedef struct Info{
  rio_file *data;
  
  /* the rio wont play files with junk in the beginning w/exception 
     to RIFF and ID3. */
  int junk; 
} Info;


class rioInstance{
 public:
  /**
   * Constructor
   * -- open /dev/usb/rio<int>
  **/
  rioInstance(const int rioNumber = 0, ostream *outstream = NULL, ostream *dstream = NULL, int d = 0);

  ~rioInstance(void);

  /**
   * makes a clean list of the files
   **/
  int refreshFileList(void);

  /**
   * updates the internal variables of the instance
   **/
  void update_info(void);

  /**
   * Iterate over the file list
   **/
  void iterate(void (*f)(rio_file *));
  void resetFileIterator(void);
  rio_file *nextFile(void);

  /**
   * Set progress bar function
   **/
  void setProgress(void (*f)(int x, int X, void *pthis), void *pthis);

  /**
   * Set output streams
   **/
  void setOutput(ostream &);
  void setErrorOutput(ostream &);

  /**
   * Debug
   **/
  void setDebugLevel(int);
  
  /**
   * commands to the rio
   *
   * -- upload takes 1 to 4 arguments and uploads an mp3
   * -- download takes the file number and attempts to read a file
   * -- update takes one argument and uploads a firmware file
   * -- delete_file deletes a file from the rio; 0 is the first file
  **/
  int upload(const char *fileName, const char *artist = NULL, const char *title = NULL, const char *album = NULL);
  int upload(char **fileList, const char *artist = NULL, const char *album = NULL);
  int download(int i, const char *fileName = NULL);
  int update(const char *fileName);
  int format(void);
  int delete_file(int);

  /**
   * Set or return the name of the rio.
  **/
  char *returnName(void) const;
  void setName(char *newname);

  /**
   * Set or return the volume level. valid values are between 0 and 20
  **/
  int returnVolume(void) const;
  void setVolume(int);

  /**
   * Query memory
   **/
  int returnUsage(void) const;
  int returnFree(void) const;

  /**
   * Return firmware version
   **/
  double returnFirm(void) const;

  /**
   * Return Total time
   **/
  long int returnTime(void) const;

  /**
   * Does this rio exist?
   **/
  bool exists(void) const;
  
  /**
   * what type of diamond mm player is it?
   **/
  enum pdmptype {RIO600 = 0, RIO800 = 1, PSAPLAY = 2};
  int returnType(void) const;

  /**
   * I don't recommend you use this directly unless you know what you are doing.
   **/
  int send_command(int, int = 0, int = 0, short unsigned int = 0x0c) const;

  /**
   * Return the number of memory devices
   * 0 = error
   * 1 = internal memory only
   * 2 = internal + external memory
   **/
  int returnNumMemdev(void) const;

  /**
   * Misc states
   **/
  int returnEquilizerState(void) const;
  int returnLightState(void) const;
  int returnContrast(void) const;
  int returnRepeatState(void) const;
  int returnPlaylist(void) const;

 private:
  struct usbdevice *device;

  void *thisptr;
  double firm;
  char *fileName;
  u_int8_t *buffer;
  long int totalTime;
  void (*progress)(int, int, void *);  

  int debug;
  int error;
  
  bool ison;

  ostream *output;
  ostream *errorO;
  
  /**
     These values come from the PREFR command
  **/
  char *name;
  int volume;
  int equilizerState;
  int lightState;
  int contrast;
  int repeatState;
  int playList;

  /**
     These are set by buildFileList
  **/
  int freeSpace;
  int usedSpace;

  int numMem, numFile;

  /**
   * So we wont upload the wrong firmware
   **/
  pdmptype type;
  
  typedef struct fileList{
    rio_file *data;
    struct fileList *next;

    fileList(rio_file *d, fileList *n) : data(d), next(n){};
    fileList() : data(0), next(0){};
    ~fileList(){delete data;}
  }fileList;

  fileList *head;
  /* for use with nextFile */
  fileList *current;

  /**
   * Make the initial file list
   **/
  int buildFileList(void);

  void fill_info(void);

  /**
   * Lower level commands to the rio
   **/
  int abort_transfer(void);

  int start_upload(void);
  int bulk_upload(Info, const char *);
  int finish_upload(Info);

  int read_block(int = 64);
  int write_block(unsigned char *, int, bool = true);

  int set_prefs(void);
  int wake(void);

  struct usbdevice *init(void);

  int get_file_info(rio_file *, int);
  int get_memdev_info(rio_mem *, int);

  /**
   * Fuction to build rio_file structures
   **/
  Info MP3getInfo(const char *);
  Info WMAgetInfo(const char *);
  Info makeDownloadableInfo(const char *);
};
#endif /* __cplusplus */
#endif /* __RIO600_H__33554432__ */
