
/*
 * $Id: mp3.h,v 1.2 2001/02/02 06:47:19 neo Exp $
 * modified to mp3.h by Nathan Hjelm
 */

#ifndef __MP3_H__
#define __MP3_H__

#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <strings.h>

typedef struct {
        char name[64]; /* the rio will allow this large a name */
	char title[30];
	char artist[30];
	char album[30];
	unsigned char genre;

        off_t size;
	int duration;
	int bitrate;
	int samplerate;
	int stereo; /* 1 = mono, 2 =stereo, 3 = intensity stereo, 4 = dual channel */
} mp3_file;

/* in case we need them */
static const unsigned char *genres[] = {
	"Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop",
	"Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Regge",
	"Rock", "Techno", "Industrial", "Ska", "Death Metal", "Pranks", "Soundtrack",
	"Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance",
	"Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel",
	"Noise", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop",
	"Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial",
	"Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy",
	"Cult", "Gangsta", "Christian Rap", "Pop/Funk", "Jungle", "Native American",
	"Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi",
	"Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll",
	"Hard Rock"
};

mp3_file getmp3_info(int fd, char *file_name);

#endif
