
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "main.h"
#include "rio.h"
#include "if_main.h"
#include "if_about.h"
#include "if_infos.h"
#include "if.h"


/* This is our private functions */
GtkWidget *create_menu_entry(char *title);
GtkWidget *create_menu_item(char *title, GtkWidget *parent, GtkSignalFunc func);
static void list_select_row(GtkCList *clist, gint row, gint column, GdkEventButton *event, gpointer user_data);
static void list_unselect_row(GtkCList *clist, gint row, gint column, GdkEventButton *event, gpointer user_data);
static void file_delete(void);
static void store_filename(GtkFileSelection *selector, gpointer user_data);
static void file_upload(void);

static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data);
static guint sb_context_id = 0;
static gchar *main_list_titles[] = { "Id", "Title", "Artist", "Duration", "Size", "BR", "SR",  "Type", "Filename" };
static gchar *selected_filename;
static GtkWidget *file_selector;


/* This is our public widgets */
GtkWidget *main_window;



/* This is our private widgets */
static GtkWidget *main_vbox;
static GtkWidget *main_menubar;
static GtkWidget *main_statusbar;
static GtkWidget *main_list;
static GtkWidget *main_clist_window;
static GtkWidget *menu_player_connect, *menu_player_disconnect;
static GtkWidget *menu_player_refresh, *menu_player_infos;
static GtkWidget *menu_player_rename;
static GtkWidget *menu_player_format, *menu_player_upgrade;
static GtkWidget *menu_file_download, *menu_file_upload, *menu_file_delete, *menu_file_quit;
static GtkWidget *menu_help_about;



/* Function if_main:
 *
 * Creates and display our main interface
*/

GtkWidget *create_menu_entry(char *title)
{
	GtkWidget *menu_entry = NULL;

	menu_entry = gtk_menu_item_new_with_label(title);
	gtk_widget_show(menu_entry);

	return menu_entry;
}

GtkWidget *create_menu_item(char *title, GtkWidget *parent, GtkSignalFunc func)
{
	GtkWidget *menu_item = NULL;

	menu_item = gtk_menu_item_new_with_label(title);
	gtk_menu_append(GTK_MENU(parent), menu_item);
	if (func != NULL)
		gtk_signal_connect_object(GTK_OBJECT(menu_item), "activate", func, GTK_OBJECT(parent));
	gtk_widget_show(menu_item);

	return menu_item;
}



void if_main()
{
	GtkWidget *menu_entry, *menu_item, *menu_sep;
	GtkAccelGroup *accel_group;

	accel_group = gtk_accel_group_new();

	main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (main_window), "destroy", GTK_SIGNAL_FUNC (gtk_main_quit), "WM destroy");
	gtk_window_set_title(GTK_WINDOW(main_window), "GTK Rio Util");
	gtk_widget_set_usize(GTK_WIDGET(main_window), 320, 200);

	gtk_signal_connect(GTK_OBJECT(main_window), "delete_event", GTK_SIGNAL_FUNC(delete_event), NULL);
	gtk_signal_connect(GTK_OBJECT(main_window), "destroy", GTK_SIGNAL_FUNC(delete_event), NULL);

	main_vbox = gtk_vbox_new(FALSE, 1);
	gtk_container_border_width(GTK_CONTAINER(main_vbox), 1);
	gtk_container_add(GTK_CONTAINER(main_window), main_vbox);
	gtk_widget_show(main_vbox);

	/* Create the main menu bar */

	main_menubar = gtk_menu_bar_new();
	gtk_box_pack_start(GTK_BOX(main_vbox), main_menubar, FALSE, TRUE, 0);
	gtk_widget_show(main_menubar);


	/* Create the File entry and sons */
	menu_item = gtk_menu_new();
	menu_entry = create_menu_entry("File");
	menu_file_upload = create_menu_item("Upload", menu_item, GTK_SIGNAL_FUNC(file_upload));
	gtk_widget_add_accelerator (menu_file_upload, "activate", accel_group, GDK_U, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	menu_file_download = create_menu_item("Download", menu_item, NULL);
	gtk_widget_add_accelerator (menu_file_download, "activate", accel_group, GDK_D, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	menu_sep = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu_item), menu_sep);
	gtk_widget_show(menu_sep);
	gtk_widget_set_sensitive(menu_sep, FALSE);
	menu_file_delete = create_menu_item("Delete", menu_item, GTK_SIGNAL_FUNC(file_delete));
	menu_sep = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu_item), menu_sep);
	gtk_widget_show(menu_sep);
	gtk_widget_set_sensitive(menu_sep, FALSE);
	menu_file_quit = create_menu_item("Quit", menu_item, GTK_SIGNAL_FUNC(gtk_main_quit));
	gtk_widget_add_accelerator (menu_file_quit, "activate", accel_group, GDK_Q, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_entry), menu_item);
	gtk_menu_bar_append(GTK_MENU_BAR(main_menubar), menu_entry);


	/* Create the Player entry and sons */
	menu_item = gtk_menu_new();
	menu_entry = create_menu_entry("Player");

	menu_player_connect = create_menu_item("Connect", menu_item, GTK_SIGNAL_FUNC(rio_open));
	gtk_widget_add_accelerator (menu_player_connect, "activate", accel_group, GDK_O, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	menu_player_disconnect = create_menu_item("Disconnect", menu_item, GTK_SIGNAL_FUNC(rio_close));
	gtk_widget_add_accelerator (menu_player_disconnect, "activate", accel_group, GDK_W, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	menu_sep = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu_item), menu_sep);
	gtk_widget_show(menu_sep);
	gtk_widget_set_sensitive(menu_sep, FALSE);

	menu_player_refresh = create_menu_item("Refresh list", menu_item, GTK_SIGNAL_FUNC(rio_list));
	gtk_widget_add_accelerator (menu_player_refresh, "activate", accel_group, GDK_R, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	menu_player_infos = create_menu_item("Informations", menu_item, GTK_SIGNAL_FUNC(if_infos));
	gtk_widget_add_accelerator (menu_player_infos, "activate", accel_group, GDK_I, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	menu_sep = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu_item), menu_sep);
	gtk_widget_show(menu_sep);
	gtk_widget_set_sensitive(menu_sep, FALSE);

	menu_player_rename = create_menu_item("Rename", menu_item, NULL);

	menu_sep = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu_item), menu_sep);
	gtk_widget_show(menu_sep);
	gtk_widget_set_sensitive(menu_sep, FALSE);

	menu_player_format = create_menu_item("Format", menu_item, NULL);

	menu_player_upgrade = create_menu_item("Upgrade Firmware", menu_item, NULL);

	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_entry), menu_item);
	gtk_menu_bar_append(GTK_MENU_BAR(main_menubar), menu_entry);


	/* Create the Help entry and sons */
	menu_item = gtk_menu_new();
	menu_entry = create_menu_entry("Help");

	menu_help_about = create_menu_item("About", menu_item, GTK_SIGNAL_FUNC(if_about));
	gtk_widget_add_accelerator (menu_help_about, "activate", accel_group, GDK_F1, 0, GTK_ACCEL_VISIBLE);

	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_entry), menu_item);
	gtk_menu_item_right_justify(GTK_MENU_ITEM(menu_entry));
	gtk_menu_bar_append(GTK_MENU_BAR(main_menubar), menu_entry);


	/* Disable the File->Close entry */
	menu_sync();

	/* Creates the clist in a scrolled window */
  main_clist_window = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(main_clist_window);
  gtk_box_pack_start(GTK_BOX(main_vbox), main_clist_window, TRUE, TRUE, 0);

	main_list = gtk_clist_new_with_titles(9, main_list_titles);
	gtk_clist_column_titles_passive(GTK_CLIST(main_list));
	gtk_signal_connect_object(GTK_OBJECT(main_list), "select_row", GTK_SIGNAL_FUNC(list_select_row), GTK_OBJECT(main_list));
	gtk_signal_connect_object(GTK_OBJECT(main_list), "unselect_row", GTK_SIGNAL_FUNC(list_unselect_row), GTK_OBJECT(main_list));

	gtk_clist_set_column_width(GTK_CLIST(main_list), 0, 20); /* Id */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 0, GTK_JUSTIFY_CENTER);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 1, 160); /* Title */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 1, GTK_JUSTIFY_LEFT);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 2, 160); /* Artist */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 2, GTK_JUSTIFY_LEFT);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 3, 60); /* Duration */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 3, GTK_JUSTIFY_CENTER);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 4, 60); /* Size */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 4, GTK_JUSTIFY_CENTER);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 5, 40); /* BitRate */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 5, GTK_JUSTIFY_CENTER);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 6, 40); /* SampleRate */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 6, GTK_JUSTIFY_CENTER);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 7, 40); /* Type */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 7, GTK_JUSTIFY_CENTER);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 8, 160); /* Filename */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 8, GTK_JUSTIFY_LEFT);

  gtk_container_add(GTK_CONTAINER(main_clist_window), main_list);
	gtk_widget_show(main_list);

	main_statusbar = gtk_statusbar_new();
	sb_context_id = gtk_statusbar_get_context_id(GTK_STATUSBAR(main_statusbar), "Main Window");
	gtk_box_pack_end(GTK_BOX(main_vbox), main_statusbar, FALSE, TRUE, 0);
	gtk_widget_show(main_statusbar);

	gtk_window_add_accel_group(GTK_WINDOW(main_window), accel_group);
	gtk_widget_show(main_window);
}



/* Function delete_event:
 *
 * This function deals with the destruction of the window, ie application.
 * The application is quitted if confirmation has been acquired.
*/
static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	if (main_quit())
	{
		main_window = NULL;
		return (FALSE);
	}

	return (TRUE);
}



guint if_main_statusbar_push(char *message)
{
	guint id;

	id = gtk_statusbar_push((GtkStatusbar *)main_statusbar, sb_context_id, message);

	/* Treat pending events to display box */
	if_treat_pending_events();

	return id;
}



void if_main_statusbar_pop(guint message_id)
{
	gtk_statusbar_remove((GtkStatusbar *)main_statusbar, sb_context_id, message_id);

	/* Treat pending events to display box */
	if_treat_pending_events();
}

void clear_main_list()
{
	gtk_clist_clear(GTK_CLIST(main_list));
}

void add_file_to_main_list(char *id, char *title, char *artist, char *duration, char *size, char *br, char *sr, char *type, char *name)
{
	gchar *data[] = { id, title, artist, duration, size, br, sr,  type, name };

	gtk_clist_append(GTK_CLIST(main_list), data);
}


void menu_sync()
{
	if (rio_get_instance())
	{
/*		gtk_widget_set_sensitive(GTK_WIDGET(menu_file_upload), TRUE);*/
		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_connect), FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_disconnect), TRUE);

		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_refresh), TRUE);
		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_infos), TRUE);
/*		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_rename), TRUE);*/
/*		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_format), TRUE);*/
/*		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_upgrade), TRUE);*/

		if ( (rio_get_nmb_files() > 0) && (rio_get_selected_file() != -1))
		{
/*			gtk_widget_set_sensitive(GTK_WIDGET(menu_file_download), TRUE);*/
			gtk_widget_set_sensitive(GTK_WIDGET(menu_file_delete), TRUE);
		}
		else
		{
			gtk_widget_set_sensitive(GTK_WIDGET(menu_file_delete), FALSE);
			gtk_widget_set_sensitive(GTK_WIDGET(menu_file_download), FALSE);
		}
	}
	else
	{
		gtk_widget_set_sensitive(GTK_WIDGET(menu_file_download), FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(menu_file_upload), FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(menu_file_delete), FALSE);

		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_connect), TRUE);
		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_disconnect), FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_refresh), FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_infos), FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_rename), FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_format), FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(menu_player_upgrade), FALSE);
	}
}


static void list_select_row(GtkCList *clist, gint row, gint column, GdkEventButton *event, gpointer user_data)
{
	gchar *text = NULL;

	if (gtk_clist_get_text(clist, row, 0, &text))
		rio_set_selected_file(atoi(text));
	else
		rio_set_selected_file(-1);

	menu_sync();
}

static void list_unselect_row(GtkCList *clist, gint row, gint column, GdkEventButton *event, gpointer user_data)
{
	rio_set_selected_file(-1);
	menu_sync();
}


static void file_delete()
{
	int id = rio_get_selected_file();
	int error;

	if (id == -1)
		return;

	error = rio_delete_file(id);
	gtk_clist_unselect_all(GTK_CLIST(main_list));
	rio_list();
}








static void store_filename(GtkFileSelection *selector, gpointer user_data)
{
	selected_filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_selector));
printf("%s\n", selected_filename);
}

static void file_upload()
{
	selected_filename = NULL;

	file_selector = gtk_file_selection_new("Please select a file to upload");

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_selector)->ok_button), "clicked", GTK_SIGNAL_FUNC(store_filename), NULL);
	gtk_window_set_modal(GTK_WINDOW(file_selector), TRUE);

	gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer)file_selector);
	gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer)file_selector);

	selected_filename = NULL;
	gtk_widget_show(file_selector);

	if (selected_filename)
		printf("Selected file is: %s\n", selected_filename);
printf("hop!\n");
}
