
#include <stdio.h>
#include <rio-cwrapper.h>
#include "if_main.h"
#include "if_error.h"
#include "rio.h"

static crioInstance rioInstance = NULL;
static guint msg_statusbar_id = 0;

#define MSG_NORIO "No Rio player found"

void rio_open()
{
  int debugLevel = 0;
	long int totalTime = 0;
	char infos[80];

	if (rioInstance)
		return;

	/* Display the searching box */
/*	if_blockbox_on(main_window, "working...", "Searching for a Rio player...\nPlease wait...");*/
	msg_statusbar_id = if_main_statusbar_push("Searching for a Rio player... Please wait...");

	/* Treat pending events to display box */
	if_treat_pending_events();

  rioInstance = init_instance(rioInstance, 0, debugLevel, 0, 0);

	/* Suppress the searching box */
	if_main_statusbar_pop(msg_statusbar_id);
/*	if_blockbox_off();*/

  if (! rioInstance)
	{
		msg_statusbar_id = if_main_statusbar_push(MSG_NORIO);
    return;
	}

  if (! exists(rioInstance))
  {
		rio_close();
		msg_statusbar_id = if_main_statusbar_push(MSG_NORIO);
    return;
  }

	if ((return_name(rioInstance) == NULL) || (return_version(rioInstance) == 0))
  {
		rio_close();
		msg_statusbar_id = if_main_statusbar_push(MSG_NORIO);
    return;
  }

	totalTime = return_time(rioInstance);

	sprintf(infos, "%s (%d Mb) - occupied: %d Mb (%d:%02d)",
		return_name(rioInstance),
		(return_usage(rioInstance)+return_free(rioInstance))/(1024*1024),
		return_usage(rioInstance)/(1024*1024),
		totalTime/60, totalTime%60
	);
	msg_statusbar_id = if_main_statusbar_push(infos);

/*
  printf("Type:         %d\n", return_type(rioInstance));
  printf("Name:         %s\n", return_name(rioInstance));
  printf("Volume:       %d\n", return_volume(rioInstance));
  printf("Usage:        %d\n", return_usage(rioInstance));
  printf("Free:         %d\n", return_free(rioInstance));
  printf("Version:      %.2f\n", return_version(rioInstance));
  printf("Time:         %d (%d:%02d)\n", totalTime, totalTime/60, totalTime%60);
  printf("Num memdev:   %d\n", return_num_memdev(rioInstance));
  printf("Eq state:     %d\n", return_eq_state(rioInstance));
  printf("Light state:  %d\n", return_light_state(rioInstance));
  printf("Contrast:     %d\n", return_contrast(rioInstance));
  printf("Rep state:    %d\n", return_rep_state(rioInstance));
  printf("Playlist:     %d\n", return_playlist(rioInstance));
*/
	rio_list();
}

void rio_close()
{
	if (!rioInstance)
		return;
	delete_instance(rioInstance);
	rioInstance = NULL;
}



void handle_file_info(rio_file *data)
{
	char id[8];
	char duration[8];
	char size[8];
	char br[8];
	char sr[8];
	char type[6];

	switch (data->type)
	{
		case 0x50524546: /* PREF */
			return;

		case 0x3347504d:
			strcpy(type, "MP3");
			break;

		case 0x20414d57:
			strcpy(type, "WMA");
			break;

		case 0x504c4341:
		case 0x45564157:
			strcpy(type, "WAV");
			break;

		default:
			strcpy(type, "???");
	}

	sprintf(id, "%d", data->file_no);
	sprintf(duration, "%d:%02d", (data->time)/60, (data->time)%60);
	if (data->size < 1024)
		sprintf(size, "%d", size);
	else if (data->size < 1024*1024)
		sprintf(size, "%.2f Kb", ((double)data->size)/((double)1024));
	else
		sprintf(size, "%.2f Mb", ((double)data->size)/((double)1024*1024));
	sprintf(br, "%d", (data->bit_rate)>>7);
	sprintf(sr, "%.1f", ((double)data->sample_rate)/((double)1000));

	add_file_to_main_list(
		id,
		data->title,
		data->artist,
		duration,
		size,
		br,
		sr,
		type,
		data->name
	);
}

void rio_list()
{
	refresh_files(rioInstance);
	iterate_files(rioInstance, handle_file_info);
}
