
#include <gtk/gtk.h>
#include "main.h"
#include "rio.h"
#include "if_main.h"
#include "if_about.h"


/* This is our private functions */
static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data);
static void get_main_menu(GtkWidget *window, GtkWidget **menubar);
static guint sb_context_id = 0;
static gchar *main_list_titles[] = { "Id", "Title", "Artist", "Duration", "Size", "BR", "SR",  "Type", "Filename" };


/* This is our public widgets */
GtkWidget *main_window;



/* This is our private widgets */
static GtkWidget *main_vbox;
static GtkWidget *main_menubar;
static GtkWidget *main_statusbar;
static GtkWidget *main_list;
static GtkWidget *main_clist_window;

static GtkItemFactoryEntry menu_items[] = {
	{ "/_File",          NULL,         NULL, 0, "<Branch>" },
	{ "/File/Open Rio",  "<control>O", rio_open, 0, NULL },
	{ "/File/Close Rio", "<control>W", rio_close, 0, NULL },
	{ "/File/sep1",      NULL,         NULL, 0, "<Separator>" },
	{ "/File/Quit",      "<control>Q", gtk_main_quit, 0, NULL },
	{ "/Help",          NULL,         NULL, 0, "<LastBranch>" },
	{ "/Help/About",    NULL,         if_about, 0, NULL },
};



/* Function if_main:
 *
 * Creates and display our main interface
*/
void if_main()
{
	main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (main_window), "destroy", GTK_SIGNAL_FUNC (gtk_main_quit), "WM destroy");
	gtk_window_set_title(GTK_WINDOW(main_window), "GTK Rio Util");
	gtk_widget_set_usize(GTK_WIDGET(main_window), 320, 200);

	gtk_signal_connect(GTK_OBJECT(main_window), "delete_event", GTK_SIGNAL_FUNC(delete_event), NULL);
	gtk_signal_connect(GTK_OBJECT(main_window), "destroy", GTK_SIGNAL_FUNC(delete_event), NULL);

	main_vbox = gtk_vbox_new(FALSE, 1);
	gtk_container_border_width(GTK_CONTAINER(main_vbox), 1);
	gtk_container_add(GTK_CONTAINER(main_window), main_vbox);
	gtk_widget_show(main_vbox);

	get_main_menu(main_window, &main_menubar);
	gtk_box_pack_start(GTK_BOX(main_vbox), main_menubar, FALSE, TRUE, 0);
	gtk_widget_show(main_menubar);

  main_clist_window = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(main_clist_window);
  gtk_box_pack_start(GTK_BOX(main_vbox), main_clist_window, TRUE, TRUE, 0);

	main_list = gtk_clist_new_with_titles(9, main_list_titles);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 0, 20); /* Id */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 0, GTK_JUSTIFY_CENTER);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 1, 160); /* Title */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 1, GTK_JUSTIFY_LEFT);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 2, 160); /* Artist */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 2, GTK_JUSTIFY_LEFT);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 3, 60); /* Duration */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 3, GTK_JUSTIFY_CENTER);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 4, 60); /* Size */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 4, GTK_JUSTIFY_CENTER);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 5, 40); /* BitRate */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 5, GTK_JUSTIFY_CENTER);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 6, 40); /* SampleRate */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 6, GTK_JUSTIFY_CENTER);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 7, 40); /* Type */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 7, GTK_JUSTIFY_CENTER);

	gtk_clist_set_column_width(GTK_CLIST(main_list), 8, 160); /* Filename */
	gtk_clist_set_column_justification(GTK_CLIST(main_list), 8, GTK_JUSTIFY_LEFT);

  gtk_container_add(GTK_CONTAINER(main_clist_window), main_list);
	gtk_widget_show(main_list);

	main_statusbar = gtk_statusbar_new();
	sb_context_id = gtk_statusbar_get_context_id(GTK_STATUSBAR(main_statusbar), "Main Window");
	gtk_box_pack_end(GTK_BOX(main_vbox), main_statusbar, FALSE, TRUE, 0);
	gtk_widget_show(main_statusbar);

	gtk_widget_show(main_window);
}



/* Function delete_event:
 *
 * This function deals with the destruction of the window, ie application.
 * The application is quitted if confirmation has been acquired.
*/
static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	if (main_quit())
	{
		main_window = NULL;
		return (FALSE);
	}

	return (TRUE);
}



/* Function get_main_menu:
 *
 * Creates a menu from the above structure
 * (from GTK tutorial)
*/
static void get_main_menu(GtkWidget *window, GtkWidget **menubar)
{
	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;
	gint nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);

	accel_group = gtk_accel_group_new();

	/* This function initializes the item factory.
		Param 1: The type of menu - can be GTK_TYPE_MENU_BAR, GTK_TYPE_MENU, or GTK_TYPE_OPTION_MENU.
		Param 2: The path of the menu.
		Param 3: A pointer to a gtk_accel_group.  The item factory sets up the accelerator table while generating menus.
	*/

	item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", accel_group);

	/* This function generates the menu items. Pass the item factory,
	   the number of items in the array, the array itself, and any
	   callback data for the the menu items. */
	gtk_item_factory_create_items(item_factory, nmenu_items, menu_items, NULL);

	/* Attach the new accelerator group to the window. */
	gtk_window_add_accel_group(GTK_WINDOW(window), accel_group);

	if (menubar)
		/* Finally, return the actual menu bar created by the item factory. */ 
		*menubar = gtk_item_factory_get_widget(item_factory, "<main>");
}



guint if_main_statusbar_push(char *message)
{
	return gtk_statusbar_push((GtkStatusbar *)main_statusbar, sb_context_id, message);
}



void if_main_statusbar_pop(guint message_id)
{
	return gtk_statusbar_remove((GtkStatusbar *)main_statusbar, sb_context_id, message_id);
}



void add_file_to_main_list(char *id, char *title, char *artist, char *duration, char *size, char *br, char *sr, char *type, char *name)
{
	gchar *data[] = { id, title, artist, duration, size, br, sr,  type, name };

	gtk_clist_append(GTK_CLIST(main_list), data);
}
